import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns a `Money` value representing the minimum a buyer can expect to pay at the current
 * step of checkout. This value excludes amounts yet to be negotiated. For example,
 * the information step might not have delivery costs calculated.
 */
function useTotalAmount() {
  return useSubscription(useExtensionApi().cost.totalAmount);
}

export { useTotalAmount };
