import { useExtensionApi } from './api.mjs';
import { useSubscription } from './subscription.mjs';

/**
 * Returns the proposed `attributes` applied to the checkout.
 */
function useAttributes() {
  return useSubscription(useExtensionApi().attributes);
}

/**
 * Returns a function to mutate the `attributes` property of the checkout.
 */
function useApplyAttributeChange() {
  return useExtensionApi().applyAttributeChange;
}

export { useApplyAttributeChange, useAttributes };
