'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

class ExtensionHasNoTargetError extends Error {
  constructor(extensionPoint) {
    super(`Cannot call 'useTarget()' on extensionPoint '${extensionPoint}'. Property 'target' is not found on api.`);
    this.name = 'ExtensionHasNoTargetError';
  }
}

/**
 * Returns the cart line the extension is attached to. This is only applicable to the `Checkout::CartLineDetails::RenderAfter` extension point.
 */
function useTarget() {
  const api$1 = api.useExtensionApi();
  if (!api$1.target) {
    throw new ExtensionHasNoTargetError(api$1.extensionPoint);
  }
  return subscription.useSubscription(api$1.target);
}

exports.useTarget = useTarget;
