'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the buyer's language, as supported by the extension.
 */
function useExtensionLanguage() {
  const {
    localization
  } = api.useExtensionApi();
  return subscription.useSubscription(localization.extensionLanguage);
}

exports.useExtensionLanguage = useExtensionLanguage;
