'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var errors = require('../errors.js');
var context = require('../context.js');

/**
 * Returns the full API object that was passed in to your
 * extension when it was created.
 */
function useExtensionApi() {
  const api = react.useContext(context.ExtensionApiContext);
  if (api == null) {
    throw new errors.CheckoutUIExtensionError('You can only call this hook when running as a UI extension.');
  }
  return api;
}

exports.useExtensionApi = useExtensionApi;
