import { readFile, glob } from '@shopify/cli-kit/node/fs';
import { joinPath, relativePath, dirname } from '@shopify/cli-kit/node/path';
export async function themeExtensionConfig(themeExtension) {
    const files = {};
    const themeFiles = await glob(joinPath(themeExtension.directory, '*/*'));
    await Promise.all(themeFiles.map(async (filepath) => {
        const relativePathName = relativePath(themeExtension.directory, filepath);
        const directoryName = dirname(relativePathName);
        const encoding = directoryName === 'assets' ? 'binary' : 'utf8';
        const fileContents = await readFile(filepath, { encoding });
        files[relativePathName] = Buffer.from(fileContents, encoding).toString('base64');
    }));
    return { theme_extension: { files } };
}
//# sourceMappingURL=theme-extension-config.js.map