import { UIExtensionSpec } from './ui.js';
import { FunctionSpec } from './functions.js';
import { ThemeExtensionSpec } from './theme.js';
import { GenericSpecification } from '../app/extensions.js';
import { Config } from '@oclif/core';
export declare function loadUIExtensionSpecifications(config: Config): Promise<UIExtensionSpec[]>;
export declare function loadFunctionSpecifications(config: Config): Promise<FunctionSpec[]>;
export declare function loadLocalUIExtensionsSpecifications(): Promise<UIExtensionSpec[]>;
export declare function loadLocalFunctionSpecifications(): Promise<FunctionSpec[]>;
export declare function loadThemeSpecifications(): Promise<ThemeExtensionSpec[]>;
/**
 * Load all specifications from the local file system AND plugins
 */
export declare function loadExtensionsSpecifications(config: Config): Promise<GenericSpecification[]>;
/**
 * Load all specifications ONLY from the local file system
 */
export declare function loadLocalExtensionsSpecifications(): Promise<GenericSpecification[]>;
