import { appFlags } from '../../flags.js';
import { deploy } from '../../services/deploy.js';
import { load as loadApp } from '../../models/app/loader.js';
import Command from '../../utilities/app-command.js';
import { loadExtensionsSpecifications } from '../../models/extensions/specifications.js';
import { Flags } from '@oclif/core';
import { globalFlags } from '@shopify/cli-kit/node/cli';
import { resolvePath, cwd } from '@shopify/cli-kit/node/path';
import { addPublicMetadata } from '@shopify/cli-kit/node/metadata';
export default class Deploy extends Command {
    async run() {
        const { args, flags } = await this.parse(Deploy);
        await addPublicMetadata(() => ({
            cmd_app_reset_used: flags.reset,
        }));
        const directory = flags.path ? resolvePath(flags.path) : cwd();
        const specifications = await loadExtensionsSpecifications(this.config);
        const app = await loadApp({ directory, specifications });
        await deploy({ app, apiKey: flags['api-key'], reset: flags.reset, force: flags.force });
    }
}
Deploy.description = 'Deploy your Shopify app.';
Deploy.flags = {
    ...globalFlags,
    ...appFlags,
    'api-key': Flags.string({
        hidden: false,
        description: 'The API key of your app.',
        env: 'SHOPIFY_FLAG_APP_API_KEY',
    }),
    reset: Flags.boolean({
        hidden: false,
        description: 'Reset all your settings.',
        env: 'SHOPIFY_FLAG_RESET',
        default: false,
    }),
    force: Flags.boolean({
        hidden: false,
        description: 'Deploy without asking for confirmation.',
        env: 'SHOPIFY_FLAG_FORCE',
        char: 'f',
        default: false,
    }),
};
//# sourceMappingURL=deploy.js.map