export declare const CreateDeployment: string;
export interface ExtensionSettings {
    uuid: string;
    config: string;
    context: string;
}
export interface CreateDeploymentVariables {
    apiKey: string;
    uuid: string;
    bundleUrl: string;
    extensions: ExtensionSettings[];
}
export interface CreateDeploymentSchema {
    deploymentCreate: {
        deployment: {
            uuid: string;
            deployedVersions: {
                extensionVersion: {
                    uuid: string;
                    registrationUuid: string;
                    validationErrors: {
                        field: string[];
                        message: string;
                    }[];
                };
            }[];
        };
        userErrors: {
            field: string[];
            message: string;
        }[];
    };
}
