'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var reactReconciler = require('react-reconciler');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var reactReconciler__default = /*#__PURE__*/_interopDefaultLegacy(reactReconciler);

const reconciler = reactReconciler__default["default"]({
  now: Date.now,
  // Timeout
  scheduleTimeout: setTimeout,
  cancelTimeout: clearTimeout,
  noTimeout: false,
  // @see https://github.com/facebook/react/blob/master/packages/react-dom/src/client/ReactDOMHostConfig.js#L408
  queueMicrotask: callback => Promise.resolve(null).then(callback).catch(handleErrorInNextTick),
  isPrimaryRenderer: true,
  supportsMutation: true,
  supportsHydration: false,
  supportsPersistence: false,

  // Context
  getRootHostContext() {
    return {};
  },

  getChildHostContext(context) {
    return context;
  },

  // Instances
  createTextInstance(text, root) {
    return root.createText(text);
  },

  createInstance(type, allProps, root) {
    const {
      children: _children,
      ...props
    } = allProps;
    return root.createComponent(type, props);
  },

  // Updates
  commitTextUpdate(text, _oldText, newText) {
    text.updateText(newText);
  },

  prepareUpdate(_instance, _type, oldProps, newProps) {
    const updateProps = {};
    let needsUpdate = false;

    for (const key in oldProps) {
      if (!has(oldProps, key) || key === 'children') {
        continue;
      }

      if (!(key in newProps)) {
        needsUpdate = true;
        updateProps[key] = undefined; // } else if (typeof oldProps[key] === 'function') {
        //   if (typeof newProps[key] === 'function') {
        //     fragment.controller.functions.exchange(
        //       oldProps[key] as Function,
        //       newProps[key] as Function,
        //     );
        //   } else {
        //     needsUpdate = true;
        //     fragment.controller.functions.revoke(oldProps[key] as Function);
        //     updateProps[key] = newProps[key];
        //   }
      } else if (oldProps[key] !== newProps[key]) {
        needsUpdate = true;
        updateProps[key] = newProps[key];
      }
    }

    for (const key in newProps) {
      if (!has(newProps, key) || key === 'children') {
        continue;
      }

      if (!(key in oldProps)) {
        needsUpdate = true;
        updateProps[key] = newProps[key];
      }
    }

    return needsUpdate ? updateProps : null;
  },

  commitUpdate(instance, payload) {
    instance.updateProps(payload);
  },

  // Update root
  appendChildToContainer(remoteRoot, child) {
    remoteRoot.appendChild(child);
  },

  insertInContainerBefore(remoteRoot, child, beforeChild) {
    remoteRoot.insertChildBefore(child, beforeChild);
  },

  removeChildFromContainer(remoteRoot, child) {
    remoteRoot.removeChild(child);
  },

  clearContainer(remoteRoot) {
    for (const child of remoteRoot.children) {
      remoteRoot.removeChild(child);
    }
  },

  // Update children
  appendInitialChild(parent, child) {
    parent.appendChild(child);
  },

  appendChild(parent, child) {
    parent.appendChild(child);
  },

  insertBefore(parent, newChild, beforeChild) {
    parent.insertChildBefore(newChild, beforeChild);
  },

  removeChild(parent, child) {
    parent.removeChild(child);
  },

  // Unknown
  finalizeInitialChildren() {
    return false;
  },

  shouldSetTextContent() {
    return false;
  },

  getPublicInstance() {},

  prepareForCommit() {
    return null;
  },

  resetAfterCommit() {},

  commitMount() {},

  preparePortalMount() {}

});

function handleErrorInNextTick(error) {
  setTimeout(() => {
    throw error;
  });
}

const {
  hasOwnProperty
} = {};

function has(object, property) {
  return hasOwnProperty.call(object, property);
}

exports.reconciler = reconciler;
